//
//  BindingSubject.swift
//  Do It
//
//  Created by Jim Dovey on 10/29/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import SwiftUI
import Combine

class BindingSubject<Value> : Subject {
    typealias Output = Value
    typealias Failure = Never
    
    private var passthrough: PassthroughSubject<Value, Never>
    private var bindingAssignmentCancellable: AnyCancellable
    
    init(binding: Binding<Value>) {
        self.passthrough = PassthroughSubject()
        self.bindingAssignmentCancellable = passthrough.sink {
            binding.wrappedValue = $0
        }
    }
    
    func send(_ value: Value) {
        passthrough.send(value)
    }
    
    func send(completion: Subscribers.Completion<Never>) {
        passthrough.send(completion: completion)
    }
    
    func send(subscription: Subscription) {
        passthrough.send(subscription: subscription)
    }
    
    func receive<S>(subscriber: S) where S : Subscriber, Failure == S.Failure, Output == S.Input {
        passthrough.receive(subscriber: subscriber)
    }
}
